
MEMORY {

//  2M Internal Flash - 512k Assigned to Z0
    int_flash	: org = 0x00180000, len = 512k

//  96K Internal SRAM Assigned to Z0
  	sram    	: org = 0x40080000, len = 96k-1k

}

DEFAULTS {

    heap_reserve = 1K
    stack_reserve = 1K

}

//
// Program layout for running out of RAM.
//


SECTIONS
{
    .PPC.EMB.sdata0 	            	    	    ABS : > sram
    .PPC.EMB.sbss0                            CLEAR ABS : > .

    .init       					: { *(.init) } > .
    .text  			            		: > .
    .vletext 				    		: > .
    .syscall 				    		: > .
    .secinfo 				    		: > .
    .rodata 				    		: > .
    .sdata2 				    		: > .
    .fixaddr			 	   		: > .
    .fixtype						: > .

    .sdabase 		        	      ALIGN(16) : > sram	
    .sdata 						: > .
    .sbss 						: > .
    .data 						: > .
    .bss 		  				: > .
    .heap                  ALIGN(16) PAD(heap_reserve)  : > .   
    .stack                 ALIGN(16) PAD(stack_reserve) : > .

//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(sram);
    __ghs_ramend    = MEMENDADDR(sram);
    __ghs_romstart  = MEMADDR(int_flash);
    __ghs_romend    = MEMENDADDR(int_flash);
    
}
